# vZ R 4.2.2 and rpact 3.3.2

# V~[Vs֐
simulation <- function(effectsize.treatment, effectsize.positivecontrol, n1, n2, selectionrule, seed, iteration) {
  library(rpact)
  library(DunnettTests)

  # I[ H
  # FvZ{Ƃ̌Qԍ0.4傫CCzΏƂƂ̌Qԍ0傫
  # 𖞂ŒpʂƁCɍpʂ̌QID𖞂ÌQȂꍇׂ͂Ă̌Q𗎂ƂĎ~D
  mySelection1 <- function(effectVector) {
    selectedArms <- effectVector > 0.4 & effectVector > effectVector[5]
    if (sum(selectedArms) > 0) {
      min.group <- min(which(selectedArms))
    } else if (sum(selectedArms) == 0) {
      min.group <- 0
    }
    if (min.group == 1) {
      return(c(T, T, F, F, F))
    } else if (min.group == 2) {
      return(c(F, T, T, F, F))
    } else if (min.group == 3) {
      return(c(F, F, T, T, F))
    } else if (min.group == 4) {
      return(c(F, F, F, T, F))
    } else if (min.group == 0) {
      return(c(F, F, F, F, F))
    }
  }

  # I[ L
  # FvZ{Ƃ̌Qԍ0.4傫CCzΏƂƂ̌Qԍ0傫
  # 𖞂ŒpʂƁCɈႢpʂ̌QID𖞂QȂꍇׂ͂Ă̌Q𗎂ƂĎ~D
  mySelection2 <- function(effectVector) {
    selectedArms <- effectVector > 0.4 & effectVector > effectVector[5]
    if (sum(selectedArms) > 0) {
      min.group <- min(which(selectedArms))
    } else if (sum(selectedArms) == 0) {
      min.group <- 0
    }
    if (min.group == 1) {
      return(c(T, F, F, F, F))
    } else if (min.group == 2) {
      return(c(T, T, F, F, F))
    } else if (min.group == 3) {
      return(c(F, T, T, F, F))
    } else if (min.group == 4) {
      return(c(F, F, T, T, F))
    } else if (min.group == 0) {
      return(c(F, F, F, F, F))
    }
  }
  
  # tK@ɂ铝ŉ͂fUC
  designInvNormal <- getDesignInverseNormal(
    kMax = 2,
    alpha = 0.025,
    sided = 1,
    informationRates = c(n1 / (n1 + n2), 1),
    typeOfDesign="noEarlyEfficacy"
  )
  
  # Adaptive DunnettiKoenig et al., 2008jŉ͂fUC
  designAdaptiveDunnett <- getDesignConditionalDunnett(
    alpha = 0.025,
    informationAtInterim = n1 / (n1 + n2),
    secondStageConditioning = TRUE
  )

  arms <- length(effectsize.treatment)
  effectsize.treatment <- c(effectsize.treatment, effectsize.positivecontrol)

  # vZ
  if(selectionrule == "mySelection1") {
    simBonferroni <- getSimulationMultiArmMeans(
      design = designInvNormal,
      activeArms = length(effectsize.treatment),
      effectMatrix = effectsize.treatment,
      stDev = 1,
      plannedSubjects = c(n1, n1 + n2),
      intersectionTest = "Bonferroni",
      typeOfShape = "userDefined",
      typeOfSelection = "userDefined",
      selectArmsFunction = mySelection1,
      successCriterion = "all",
      maxNumberOfIterations = iteration,
      seed = seed
    )
    simAdaptiveDunnett <- getSimulationMultiArmMeans(
      design = designAdaptiveDunnett,
      activeArms = length(effectsize.treatment),
      effectMatrix = effectsize.treatment,
      stDev = 1,
      plannedSubjects = c(n1, n1 + n2),
      intersectionTest = "Dunnett",
      typeOfShape = "userDefined",
      typeOfSelection = "userDefined",
      selectArmsFunction = mySelection1,
      successCriterion = "all",
      maxNumberOfIterations = iteration,
      seed = seed
    )
  }
  if(selectionrule == "mySelection2") {
    simBonferroni <- getSimulationMultiArmMeans(
      design = designInvNormal ,
      activeArms = length(effectsize.treatment),
      effectMatrix = effectsize.treatment,
      stDev = 1,
      plannedSubjects = c(n1, n1 + n2),
      intersectionTest = "Bonferroni",
      typeOfShape = "userDefined",
      typeOfSelection = "userDefined",
      selectArmsFunction = mySelection2,
      successCriterion = "all",
      maxNumberOfIterations = iteration,
      seed = seed
    )
    simAdaptiveDunnett <- getSimulationMultiArmMeans(
      design = designAdaptiveDunnett,
      activeArms = length(effectsize.treatment),
      effectMatrix = effectsize.treatment,
      stDev = 1,
      plannedSubjects = c(n1, n1 + n2),
      intersectionTest = "Dunnett",
      typeOfShape = "userDefined",
      typeOfSelection = "userDefined",
      selectArmsFunction = mySelection2,
      successCriterion = "all",
      maxNumberOfIterations = iteration,
      seed = seed
    )
  }
  
  # ʂf[^t[Ɋi[
  resultBonferroni <- as.data.frame(simBonferroni)
  resultDunnett <- as.data.frame(simAdaptiveDunnett)
  
  # ʂv񂷂R[h
  # kable(summary(simBonferroni))
  # kable(summary(simAdaptiveDunnett))
  
  # ʂ̃f[^t[ҏW
  dataBonferroni <- dataAdaptiveDunnett <- data.frame(
    iteration = 1:iteration,
    effectEstimate.IA.arm1 = NA,
    effectEstimate.IA.arm2 = NA,
    effectEstimate.IA.arm3 = NA,
    effectEstimate.IA.arm4 = NA,
    effectEstimate.FA.arm1 = NA,
    effectEstimate.FA.arm2 = NA,
    effectEstimate.FA.arm3 = NA,
    effectEstimate.FA.arm4 = NA,
    effectEstimate.stage2.arm1 = NA,
    effectEstimate.stage2.arm2 = NA,
    effectEstimate.stage2.arm3 = NA,
    effectEstimate.stage2.arm4 = NA,
    testStatistic.IA.arm1 = NA,
    testStatistic.IA.arm2 = NA,
    testStatistic.IA.arm3 = NA,
    testStatistic.IA.arm4 = NA,
    testStatistic.FA.arm1 = NA,
    testStatistic.FA.arm2 = NA,
    testStatistic.FA.arm3 = NA,
    testStatistic.FA.arm4 = NA,
    pValue.IA.arm1 = NA,
    pValue.IA.arm2 = NA,
    pValue.IA.arm3 = NA,
    pValue.IA.arm4 = NA,
    pValue.FA.arm1 = NA,
    pValue.FA.arm2 = NA,
    pValue.FA.arm3 = NA,
    pValue.FA.arm4 = NA,
    rejectPerStage.IA.arm1 = NA,
    rejectPerStage.IA.arm2 = NA,
    rejectPerStage.IA.arm3 = NA,
    rejectPerStage.IA.arm4 = NA,
    rejectPerStage.FA.arm1 = NA,
    rejectPerStage.FA.arm2 = NA,
    rejectPerStage.FA.arm3 = NA,
    rejectPerStage.FA.arm4 = NA
  )
  for (i in 1:arms) {
    eval(parse(text=paste("vectorBonferroni.IA.arm", i, "<- simBonferroni$.data$stageNumber == 1 & simBonferroni$.data$armNumber == ", i, sep="")))
    eval(parse(text=paste("dataBonferroni.IA.arm", i,  "<- simBonferroni$.data[vectorBonferroni.IA.arm", i, ",]", sep="")))
    eval(parse(text=paste("dataBonferroni$effectEstimate.IA.arm", i, "[dataBonferroni.IA.arm", i, "$iterationNumber] <- dataBonferroni.IA.arm", i, "$effectEstimate", sep="")))
    eval(parse(text=paste("dataBonferroni$testStatistic.IA.arm", i, "[dataBonferroni.IA.arm", i, "$iterationNumber] <- dataBonferroni.IA.arm", i, "$testStatistic", sep="")))
    eval(parse(text=paste("dataBonferroni$pValue.IA.arm", i, "[dataBonferroni.IA.arm", i, "$iterationNumber] <- dataBonferroni.IA.arm", i, "$pValue", sep="")))
    eval(parse(text=paste("dataBonferroni$rejectPerStage.IA.arm", i, "[dataBonferroni.IA.arm", i, "$iterationNumber] <- dataBonferroni.IA.arm", i, "$rejectPerStage", sep="")))
    eval(parse(text=paste("vectorBonferroni.FA.arm", i, "<- simBonferroni$.data$stageNumber == 2 & simBonferroni$.data$armNumber == ", i, sep="")))
    eval(parse(text=paste("dataBonferroni.FA.arm", i,  "<- simBonferroni$.data[vectorBonferroni.FA.arm", i, ",]", sep="")))
    eval(parse(text=paste("dataBonferroni$effectEstimate.FA.arm", i, "[dataBonferroni.FA.arm", i, "$iterationNumber] <- dataBonferroni.FA.arm", i, "$effectEstimate", sep="")))
    eval(parse(text=paste("dataBonferroni$testStatistic.FA.arm", i, "[dataBonferroni.FA.arm", i, "$iterationNumber] <- dataBonferroni.FA.arm", i, "$testStatistic", sep="")))
    eval(parse(text=paste("dataBonferroni$pValue.FA.arm", i, "[dataBonferroni.FA.arm", i, "$iterationNumber] <- dataBonferroni.FA.arm", i, "$pValue", sep="")))
    eval(parse(text=paste("dataBonferroni$rejectPerStage.FA.arm", i, "[dataBonferroni.FA.arm", i, "$iterationNumber] <- dataBonferroni.FA.arm", i, "$rejectPerStage", sep="")))
    eval(parse(text=paste("dataBonferroni$effectEstimate.stage2.arm", i, "[!is.na(dataBonferroni$effectEstimate.FA.arm", i, ")] <- ((n1 + n2)/n2) * dataBonferroni$effectEstimate.FA.arm", i, "[!is.na(dataBonferroni$effectEstimate.FA.arm", i, ")] -   (n1/n2) * dataBonferroni$effectEstimate.IA.arm", i, "[!is.na(dataBonferroni$effectEstimate.FA.arm", i, ")]", sep="")))
    eval(parse(text=paste("vectorAdaptiveDunnett.IA.arm", i, "<- simAdaptiveDunnett$.data$stageNumber == 1 & simAdaptiveDunnett$.data$armNumber == ", i, sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett.IA.arm", i,  "<- simAdaptiveDunnett$.data[vectorAdaptiveDunnett.IA.arm", i, ",]", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$effectEstimate.IA.arm", i, "[dataAdaptiveDunnett.IA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.IA.arm", i, "$effectEstimate", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$testStatistic.IA.arm", i, "[dataAdaptiveDunnett.IA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.IA.arm", i, "$testStatistic", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$pValue.IA.arm", i, "[dataAdaptiveDunnett.IA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.IA.arm", i, "$pValue", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$rejectPerStage.IA.arm", i, "[dataAdaptiveDunnett.IA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.IA.arm", i, "$rejectPerStage", sep="")))
    eval(parse(text=paste("vectorAdaptiveDunnett.FA.arm", i, "<- simAdaptiveDunnett$.data$stageNumber == 2 & simAdaptiveDunnett$.data$armNumber == ", i, sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett.FA.arm", i,  "<- simAdaptiveDunnett$.data[vectorAdaptiveDunnett.FA.arm", i, ",]", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$effectEstimate.FA.arm", i, "[dataAdaptiveDunnett.FA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.FA.arm", i, "$effectEstimate", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$testStatistic.FA.arm", i, "[dataAdaptiveDunnett.FA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.FA.arm", i, "$testStatistic", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$pValue.FA.arm", i, "[dataAdaptiveDunnett.FA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.FA.arm", i, "$pValue", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$rejectPerStage.FA.arm", i, "[dataAdaptiveDunnett.FA.arm", i, "$iterationNumber] <- dataAdaptiveDunnett.FA.arm", i, "$rejectPerStage", sep="")))
    eval(parse(text=paste("dataAdaptiveDunnett$effectEstimate.stage2.arm", i, "[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm", i, ")] <- ((n1 + n2)/n2) * dataAdaptiveDunnett$effectEstimate.FA.arm", i, "[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm", i, ")] - (n1/n2) * dataAdaptiveDunnett$effectEstimate.IA.arm", i, "[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm", i, ")]", sep="")))
  }
  
  # ȂƂ1̉Lӂł銄
  power.Bonferroni.atleastone <- simBonferroni$rejectAtLeastOne
  power.AdaptiveDunnett.atleastone <- simAdaptiveDunnett$rejectAtLeastOne
  
  # LӂƂȂ銄iQʁj
  power.Bonferroni <- matrix(simBonferroni$rejectedArmsPerStage[1:(2*arms)], ncol=arms)[2,]
  power.AdaptiveDunnett <- matrix(simAdaptiveDunnett$rejectedArmsPerStage[1:(2*arms)], ncol=arms)[2,]
  
  # ԉ͂Ō؂鎡ÌQɑIŗLӂƂȂ銄iQʁj
  conditionalpower.Bonferroni <- c(
    mean(dataBonferroni$rejectPerStage.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)]),
    mean(dataBonferroni$rejectPerStage.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)]),
    mean(dataBonferroni$rejectPerStage.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)]),
    mean(dataBonferroni$rejectPerStage.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)]))
  conditionalpower.AdaptiveDunnett <- c(
    mean(dataAdaptiveDunnett$rejectPerStage.FA.arm1[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm1)]),
    mean(dataAdaptiveDunnett$rejectPerStage.FA.arm2[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm2)]),
    mean(dataAdaptiveDunnett$rejectPerStage.FA.arm3[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm3)]),
    mean(dataAdaptiveDunnett$rejectPerStage.FA.arm4[!is.na(dataAdaptiveDunnett$effectEstimate.FA.arm4)]))
  
  # ÌQeXe[Wɐiފi1sڂ1Xe[WC2sڂ2Xe[Wj
  selectarms.prob <- matrix(simBonferroni$selectedArms[1:(2*arms)], ncol=arms)[2,1:arms]
  
  # IꂽÌQ̐
  numbergroups <- numbergroups.treatment <-
    (!is.na(dataBonferroni$effectEstimate.stage2.arm1)) +
    (!is.na(dataBonferroni$effectEstimate.stage2.arm2)) +
    (!is.na(dataBonferroni$effectEstimate.stage2.arm3)) +
    (!is.na(dataBonferroni$effectEstimate.stage2.arm4))
  numberarms.mean <- mean(numbergroups)
  numberarms.table <- table(numbergroups) / iteration
  numberarms.0 <- numberarms.table[which(unlist(labels(numberarms.table)) == 0)]
  numberarms.1 <- numberarms.table[which(unlist(labels(numberarms.table)) == 1)]
  numberarms.2 <- numberarms.table[which(unlist(labels(numberarms.table)) == 2)]
  numberarms.0 <- ifelse(length(numberarms.0) == 0, 0, numberarms.0)
  numberarms.1 <- ifelse(length(numberarms.1) == 0, 0, numberarms.1)
  numberarms.2 <- ifelse(length(numberarms.2) == 0, 0, numberarms.2)
  
  # eÌQ̕ϗᐔƎŜ̕ϗᐔ
  # Ŝɂ́CvZ{QƗzΏƌQ܂߂Ă
  samplesize <- as.data.frame(simBonferroni$sampleSizes)[,1:arms]
  samplesize.mean.overall <- sum(samplesize, numberarms.0 * 2 * n1, (1 - numberarms.0) * 2 * (n1 + n2))
  samplesize.mean.arm <- as.vector(apply(samplesize, 2, sum))

  # ŒfUCł̌óCtóiBonferroni, step-down Dunnettj
  test.stage2 <- matrix(c(
    dataBonferroni$effectEstimate.stage2.arm1 / sqrt(2/n2),
    dataBonferroni$effectEstimate.stage2.arm2 / sqrt(2/n2),
    dataBonferroni$effectEstimate.stage2.arm3 / sqrt(2/n2),
    dataBonferroni$effectEstimate.stage2.arm4 / sqrt(2/n2)), ncol = arms)
  Bonferroni.fixed <- 1 - pnorm(test.stage2)
  for (i in which(numbergroups.treatment > 0)) {
    Bonferroni.fixed[i,] <- Bonferroni.fixed[i,] < (0.025 / numbergroups.treatment[i])
  }
  Bonferroni.fixed <- Bonferroni.fixed[apply(is.na(Bonferroni.fixed), 1, sum) < arms,]
  conditionalpower.Bonferroni.fixed.atleastone <- mean(apply(Bonferroni.fixed, 1, sum, na.rm=T) > 0)
  conditionalpower.Bonferroni.fixed <- as.vector(apply(Bonferroni.fixed, 2, mean, na.rm=T))
  Bonferroni.fixed[is.na(Bonferroni.fixed)] <- FALSE
  power.Bonferroni.fixed.atleastone <- mean(apply(Bonferroni.fixed, 1, sum) > 0)
  power.Bonferroni.fixed <- as.vector(apply(Bonferroni.fixed, 2, mean))
  
  StepDownDunnett.fixed <- matrix(NA, ncol = 4, nrow = iteration)
  for (i in 1:iteration) {
    a <- numbergroups.treatment[i]
    if (a > 1) {
      cv <- cvSDDT(k = a, alpha = 0.025, alternative = "U", corr = 0.5, df = n2 * (a + 1) - (a + 1))
      order.vector <- order(test.stage2[i,])
      for (j in 1:a) {
        StepDownDunnett.fixed[i,order.vector[j]] <- test.stage2[i,order.vector[j]] > cv[j]
        if (StepDownDunnett.fixed[i,order.vector[j]] == FALSE) break
      }
    } else if (a == 1) {
      StepDownDunnett.fixed[i,] <- test.stage2[i,] > qnorm(1-0.025)
    }
  }
  conditionalpower.StepDownDunnett.fixed.atleastone <- mean(apply(StepDownDunnett.fixed[apply(is.na(StepDownDunnett.fixed), 1, sum) < 4,], 1, sum, na.rm=T) > 0)
  conditionalpower.StepDownDunnett.fixed <- as.vector(apply(StepDownDunnett.fixed, 2, mean, na.rm=T))
  StepDownDunnett.fixed[is.na(StepDownDunnett.fixed)] <- FALSE
  power.StepDownDunnett.fixed.atleastone <- mean(apply(StepDownDunnett.fixed, 1, sum) > 0)
  power.StepDownDunnett.fixed <- as.vector(apply(StepDownDunnett.fixed, 2, mean))
  
  # l
  mean.stage1.arm1 <- mean(dataBonferroni$effectEstimate.IA.arm1)
  mean.stage1.arm2 <- mean(dataBonferroni$effectEstimate.IA.arm2)
  mean.stage1.arm3 <- mean(dataBonferroni$effectEstimate.IA.arm3)
  mean.stage1.arm4 <- mean(dataBonferroni$effectEstimate.IA.arm4)
  mean.stage1 <- c(mean.stage1.arm1, mean.stage1.arm2, mean.stage1.arm3, mean.stage1.arm4)
  mean.overall.arm1 <- mean(c(
    dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)],
    dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)]))
  mean.overall.arm2 <- mean(c(
    dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)],
    dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)]))
  mean.overall.arm3 <- mean(c(
    dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)],
    dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)]))
  mean.overall.arm4 <- mean(c(
    dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)],
    dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)]))
  mean.overall <- c(mean.overall.arm1, mean.overall.arm2, mean.overall.arm3, mean.overall.arm4)
  conditionalmean.select.stage1.arm1 <- mean(dataBonferroni$effectEstimate.IA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)])
  conditionalmean.select.stage1.arm2 <- mean(dataBonferroni$effectEstimate.IA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)])
  conditionalmean.select.stage1.arm3 <- mean(dataBonferroni$effectEstimate.IA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)])
  conditionalmean.select.stage1.arm4 <- mean(dataBonferroni$effectEstimate.IA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)])
  conditionalmean.select.stage1 <- c(conditionalmean.select.stage1.arm1, conditionalmean.select.stage1.arm2, conditionalmean.select.stage1.arm3, conditionalmean.select.stage1.arm4)
  conditionalmean.nonselect.stage1.arm1 <- mean(dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)])
  conditionalmean.nonselect.stage1.arm2 <- mean(dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)])
  conditionalmean.nonselect.stage1.arm3 <- mean(dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)])
  conditionalmean.nonselect.stage1.arm4 <- mean(dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)])
  conditionalmean.nonselect.stage1 <- c(conditionalmean.nonselect.stage1.arm1, conditionalmean.nonselect.stage1.arm2, conditionalmean.nonselect.stage1.arm3, conditionalmean.nonselect.stage1.arm4)
  conditionalmean.select.stage2.arm1 <- mean(dataBonferroni$effectEstimate.stage2.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)])
  conditionalmean.select.stage2.arm2 <- mean(dataBonferroni$effectEstimate.stage2.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)])
  conditionalmean.select.stage2.arm3 <- mean(dataBonferroni$effectEstimate.stage2.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)])
  conditionalmean.select.stage2.arm4 <- mean(dataBonferroni$effectEstimate.stage2.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)])
  conditionalmean.select.stage2 <- c(conditionalmean.select.stage2.arm1, conditionalmean.select.stage2.arm2, conditionalmean.select.stage2.arm3, conditionalmean.select.stage2.arm4)
  conditionalmean.select.overall.arm1 <- mean(dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)])
  conditionalmean.select.overall.arm2 <- mean(dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)])
  conditionalmean.select.overall.arm3 <- mean(dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)])
  conditionalmean.select.overall.arm4 <- mean(dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)])
  conditionalmean.select.overall <- c(conditionalmean.select.overall.arm1, conditionalmean.select.overall.arm2, conditionalmean.select.overall.arm3, conditionalmean.select.overall.arm4)
  
  # oCAX
  bias.stage1 <- mean.stage1 - effectsize.treatment[1:arms]
  bias.overall <- mean.overall - effectsize.treatment[1:arms]
  conditionalbias.select.stage1 <- conditionalmean.select.stage1 - effectsize.treatment[1:arms]
  conditionalbias.nonselect.stage1 <- conditionalmean.nonselect.stage1 - effectsize.treatment[1:arms]
  conditionalbias.select.stage2 <- conditionalmean.select.stage2 - effectsize.treatment[1:arms]
  conditionalbias.select.overall <- conditionalmean.select.overall - effectsize.treatment[1:arms]
  
  # MSE
  mse.stage1.arm1 <- mean((dataBonferroni$effectEstimate.IA.arm1 - effectsize.treatment[1])^2)
  mse.stage1.arm2 <- mean((dataBonferroni$effectEstimate.IA.arm2 - effectsize.treatment[2])^2)
  mse.stage1.arm3 <- mean((dataBonferroni$effectEstimate.IA.arm3 - effectsize.treatment[3])^2)
  mse.stage1.arm4 <- mean((dataBonferroni$effectEstimate.IA.arm4 - effectsize.treatment[4])^2)
  mse.stage1 <- c(mse.stage1.arm1, mse.stage1.arm2, mse.stage1.arm3, mse.stage1.arm4)
  mse.overall.arm1 <- mean((c(
    dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)],
    dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)]) - effectsize.treatment[1])^2)
  mse.overall.arm2 <- mean((c(
    dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)],
    dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)]) - effectsize.treatment[2])^2)
  mse.overall.arm3 <- mean((c(
    dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)],
    dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)]) - effectsize.treatment[3])^2)
  mse.overall.arm4 <- mean((c(
    dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)],
    dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)]) - effectsize.treatment[4])^2)
  mse.overall <- c(mse.overall.arm1, mse.overall.arm2, mse.overall.arm3, mse.overall.arm4)
  conditionalmse.select.stage1.arm1 <- mean((dataBonferroni$effectEstimate.IA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - effectsize.treatment[1])^2)
  conditionalmse.select.stage1.arm2 <- mean((dataBonferroni$effectEstimate.IA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - effectsize.treatment[2])^2)
  conditionalmse.select.stage1.arm3 <- mean((dataBonferroni$effectEstimate.IA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - effectsize.treatment[3])^2)
  conditionalmse.select.stage1.arm4 <- mean((dataBonferroni$effectEstimate.IA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - effectsize.treatment[4])^2)
  conditionalmse.select.stage1 <- c(conditionalmse.select.stage1.arm1, conditionalmse.select.stage1.arm2, conditionalmse.select.stage1.arm3, conditionalmse.select.stage1.arm4)
  conditionalmse.nonselect.stage1.arm1 <- mean((dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)] - effectsize.treatment[1])^2)
  conditionalmse.nonselect.stage1.arm2 <- mean((dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)] - effectsize.treatment[2])^2)
  conditionalmse.nonselect.stage1.arm3 <- mean((dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)] - effectsize.treatment[3])^2)
  conditionalmse.nonselect.stage1.arm4 <- mean((dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)] - effectsize.treatment[4])^2)
  conditionalmse.nonselect.stage1 <- c(conditionalmse.nonselect.stage1.arm1, conditionalmse.nonselect.stage1.arm2, conditionalmse.nonselect.stage1.arm3, conditionalmse.nonselect.stage1.arm4)
  conditionalmse.select.stage2.arm1 <- mean((dataBonferroni$effectEstimate.stage2.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - effectsize.treatment[1])^2)
  conditionalmse.select.stage2.arm2 <- mean((dataBonferroni$effectEstimate.stage2.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - effectsize.treatment[2])^2)
  conditionalmse.select.stage2.arm3 <- mean((dataBonferroni$effectEstimate.stage2.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - effectsize.treatment[3])^2)
  conditionalmse.select.stage2.arm4 <- mean((dataBonferroni$effectEstimate.stage2.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - effectsize.treatment[4])^2)
  conditionalmse.select.stage2 <- c(conditionalmse.select.stage2.arm1, conditionalmse.select.stage2.arm2, conditionalmse.select.stage2.arm3, conditionalmse.select.stage2.arm4)
  conditionalmse.select.overall.arm1 <- mean((dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - effectsize.treatment[1])^2)
  conditionalmse.select.overall.arm2 <- mean((dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - effectsize.treatment[2])^2)
  conditionalmse.select.overall.arm3 <- mean((dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - effectsize.treatment[3])^2)
  conditionalmse.select.overall.arm4 <- mean((dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - effectsize.treatment[4])^2)
  conditionalmse.select.overall <- c(conditionalmse.select.overall.arm1, conditionalmse.select.overall.arm2, conditionalmse.select.overall.arm3, conditionalmse.select.overall.arm4)
  
  # 핢m
  lowerCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1 - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2 - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3 - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4 - qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1 + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2 + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3 + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4 + qnorm(1-0.025) * sqrt(2/n1)
  coverageCI.stage1.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  coverageCI.stage1.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  coverageCI.stage1.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  coverageCI.stage1.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  coverageCI.stage1 <- c(coverageCI.stage1.arm1, coverageCI.stage1.arm2, coverageCI.stage1.arm3, coverageCI.stage1.arm4)
  lowerCI.arm1 <- c(dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  lowerCI.arm2 <- c(dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  lowerCI.arm3 <- c(dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  lowerCI.arm4 <- c(dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  upperCI.arm1 <- c(dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  upperCI.arm2 <- c(dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  upperCI.arm3 <- c(dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  upperCI.arm4 <- c(dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/n1),
    dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/(n1 + n2)))
  coverageCI.overall.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  coverageCI.overall.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  coverageCI.overall.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  coverageCI.overall.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  coverageCI.overall <- c(coverageCI.overall.arm1, coverageCI.overall.arm2, coverageCI.overall.arm3, coverageCI.overall.arm4)
  lowerCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/n1)
  conditionalcoverageCI.select.stage1.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  conditionalcoverageCI.select.stage1.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  conditionalcoverageCI.select.stage1.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  conditionalcoverageCI.select.stage1.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  conditionalcoverageCI.select.stage1 <- c(conditionalcoverageCI.select.stage1.arm1, conditionalcoverageCI.select.stage1.arm2, conditionalcoverageCI.select.stage1.arm3, conditionalcoverageCI.select.stage1.arm4)
  lowerCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/n1)
  lowerCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm1 <- dataBonferroni$effectEstimate.IA.arm1[is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm2 <- dataBonferroni$effectEstimate.IA.arm2[is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm3 <- dataBonferroni$effectEstimate.IA.arm3[is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/n1)
  upperCI.arm4 <- dataBonferroni$effectEstimate.IA.arm4[is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/n1)
  conditionalcoverageCI.nonselect.stage1.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  conditionalcoverageCI.nonselect.stage1.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  conditionalcoverageCI.nonselect.stage1.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  conditionalcoverageCI.nonselect.stage1.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  conditionalcoverageCI.nonselect.stage1 <- c(conditionalcoverageCI.nonselect.stage1.arm1, conditionalcoverageCI.nonselect.stage1.arm2, conditionalcoverageCI.nonselect.stage1.arm3, conditionalcoverageCI.nonselect.stage1.arm4)
  lowerCI.arm1 <- dataBonferroni$effectEstimate.stage2.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/n2)
  lowerCI.arm2 <- dataBonferroni$effectEstimate.stage2.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/n2)
  lowerCI.arm3 <- dataBonferroni$effectEstimate.stage2.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/n2)
  lowerCI.arm4 <- dataBonferroni$effectEstimate.stage2.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/n2)
  upperCI.arm1 <- dataBonferroni$effectEstimate.stage2.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/n2)
  upperCI.arm2 <- dataBonferroni$effectEstimate.stage2.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/n2)
  upperCI.arm3 <- dataBonferroni$effectEstimate.stage2.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/n2)
  upperCI.arm4 <- dataBonferroni$effectEstimate.stage2.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/n2)
  conditionalcoverageCI.select.stage2.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  conditionalcoverageCI.select.stage2.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  conditionalcoverageCI.select.stage2.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  conditionalcoverageCI.select.stage2.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  conditionalcoverageCI.select.stage2 <- c(conditionalcoverageCI.select.stage2.arm1, conditionalcoverageCI.select.stage2.arm2, conditionalcoverageCI.select.stage2.arm3, conditionalcoverageCI.select.stage2.arm4)
  lowerCI.arm1 <- dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] - qnorm(1-0.025) * sqrt(2/(n1 + n2))
  lowerCI.arm2 <- dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] - qnorm(1-0.025) * sqrt(2/(n1 + n2))
  lowerCI.arm3 <- dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] - qnorm(1-0.025) * sqrt(2/(n1 + n2))
  lowerCI.arm4 <- dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] - qnorm(1-0.025) * sqrt(2/(n1 + n2))
  upperCI.arm1 <- dataBonferroni$effectEstimate.FA.arm1[!is.na(dataBonferroni$effectEstimate.FA.arm1)] + qnorm(1-0.025) * sqrt(2/(n1 + n2))
  upperCI.arm2 <- dataBonferroni$effectEstimate.FA.arm2[!is.na(dataBonferroni$effectEstimate.FA.arm2)] + qnorm(1-0.025) * sqrt(2/(n1 + n2))
  upperCI.arm3 <- dataBonferroni$effectEstimate.FA.arm3[!is.na(dataBonferroni$effectEstimate.FA.arm3)] + qnorm(1-0.025) * sqrt(2/(n1 + n2))
  upperCI.arm4 <- dataBonferroni$effectEstimate.FA.arm4[!is.na(dataBonferroni$effectEstimate.FA.arm4)] + qnorm(1-0.025) * sqrt(2/(n1 + n2))
  conditionalcoverageCI.select.overall.arm1 <- mean(lowerCI.arm1 < effectsize.treatment[1] & upperCI.arm1 > effectsize.treatment[1])
  conditionalcoverageCI.select.overall.arm2 <- mean(lowerCI.arm2 < effectsize.treatment[2] & upperCI.arm2 > effectsize.treatment[2])
  conditionalcoverageCI.select.overall.arm3 <- mean(lowerCI.arm3 < effectsize.treatment[3] & upperCI.arm3 > effectsize.treatment[3])
  conditionalcoverageCI.select.overall.arm4 <- mean(lowerCI.arm4 < effectsize.treatment[4] & upperCI.arm4 > effectsize.treatment[4])
  conditionalcoverageCI.select.overall <- c(conditionalcoverageCI.select.overall.arm1, conditionalcoverageCI.select.overall.arm2, conditionalcoverageCI.select.overall.arm3, conditionalcoverageCI.select.overall.arm4)

  # ʂo
  result <- list(
    effectsize.treatment = effectsize.treatment[1:arms],
    effectsize.positivecontrol = effectsize.positivecontrol,
    n1 = n1,
    n2 = n2,
    seed = seed,
    iteration = iteration,
    power.Bonferroni.atleastone = power.Bonferroni.atleastone,
    power.AdaptiveDunnett.atleastone = power.AdaptiveDunnett.atleastone,
    power.Bonferroni = power.Bonferroni,
    power.AdaptiveDunnett = power.AdaptiveDunnett,
    conditionalpower.Bonferroni = conditionalpower.Bonferroni,
    conditionalpower.AdaptiveDunnett = conditionalpower.AdaptiveDunnett,
    power.Bonferroni.fixed.atleastone = power.Bonferroni.fixed.atleastone,
    power.Bonferroni.fixed = power.Bonferroni.fixed,
    power.StepDownDunnett.fixed.atleastone = power.StepDownDunnett.fixed.atleastone,
    power.StepDownDunnett.fixed = power.StepDownDunnett.fixed,
    conditionalpower.Bonferroni.fixed.atleastone = conditionalpower.Bonferroni.fixed.atleastone,
    conditionalpower.Bonferroni.fixed = conditionalpower.Bonferroni.fixed,
    conditionalpower.StepDownDunnett.fixed.atleastone = conditionalpower.StepDownDunnett.fixed.atleastone,
    conditionalpower.StepDownDunnett.fixed = conditionalpower.StepDownDunnett.fixed,
    selectarms.prob = selectarms.prob,
    numberarms.mean = numberarms.mean,
    numberarms.0 = numberarms.0,
    numberarms.1 = numberarms.1,
    numberarms.2 = numberarms.2,
    samplesize.mean.overall = samplesize.mean.overall,
    samplesize.mean.arm = samplesize.mean.arm,
    mean.stage1 = mean.stage1,
    mean.overall = mean.overall,
    conditionalmean.select.stage1 = conditionalmean.select.stage1,
    conditionalmean.nonselect.stage1 = conditionalmean.nonselect.stage1,
    conditionalmean.select.stage2 = conditionalmean.select.stage2,
    conditionalmean.select.overall = conditionalmean.select.overall,
    bias.stage1 = bias.stage1,
    bias.overall = bias.overall,
    conditionalbias.select.stage1 = conditionalbias.select.stage1,
    conditionalbias.nonselect.stage1 = conditionalbias.nonselect.stage1,
    conditionalbias.select.stage2 = conditionalbias.select.stage2,
    conditionalbias.select.overall = conditionalbias.select.overall,
    mse.stage1 = mse.stage1,
    mse.overall = mse.overall,
    conditionalmse.select.stage1 = conditionalmse.select.stage1,
    conditionalmse.nonselect.stage1 = conditionalmse.nonselect.stage1,
    conditionalmse.select.stage2 = conditionalmse.select.stage2,
    conditionalmse.select.overall = conditionalmse.select.overall,
    coverageCI.stage1 = coverageCI.stage1,
    coverageCI.overall = coverageCI.overall,
    conditionalcoverageCI.select.stage1 = conditionalcoverageCI.select.stage1,
    conditionalcoverageCI.nonselect.stage1 = conditionalcoverageCI.nonselect.stage1,
    conditionalcoverageCI.select.stage2 = conditionalcoverageCI.select.stage2,
    conditionalcoverageCI.select.overall = conditionalcoverageCI.select.overall
  )
  result
}
