/************************************************************************************
ÌQĨV~[V}N
@ %TSsim}N̓ǂݍ݂уV~[ṼViIݒ
Name:        TSsimulation_macro.sas
Author:      Masahiro Takatsu
Version:     1.4
Last update: 2024/09/10
************************************************************************************/

*=pʐύXꍇ́C}N̈(m1-m4)ǉ/폜;
%macro TSsim(no, m1, m2, m3, m4, m9); 

*===Jn======================================================;
proc datasets lib=work kill nolist; run ; quit; ;

data _NULL_;
  call symput("start_time", datetime());
  call symput("start_timec", put(datetime(), NLDATMS19.));
  call symput("n", %eval(&n1.+&n2.));
  call symputx("rep", ceil(&nsim./10000)-1 );
run;

%put simulation no=&no. start_time=&start_timec.;

data _NULL_; *=sɂERR̂߁CV~[V񐔂10000𒴂ꍇ10000񂲂ƂɎs;
  %do i=0 %to &rep.;
    call symputx("st&i.", %eval(1+&i.*10000) ); *=1, 10001, 20001, c;
    call symputx("en&i.", min(&nsim., %eval((&i.+1)*10000)) ); *=10000, 20000, 30000, c, V~[V;
  %end;
run;
*===================================================================;

*===V~[Vf[^======================================;
data data01; *=IQ̑2Xe[W̃f[^Ă_ɒ;
  do sim=1 to &nsim.;
    call streaminit(%eval(&no.*1234));
    do i=1 to &n.;
      if i<=&n1. then stage=1;
      else stage=2;

      arm=0; *=vZ{Q;
      res=rand("Normal", &m0., &sd.);
      res_true=&m0.;
      output;

      %do i=1 %to &narm.; *=pʌQ;
        arm=&i.;
        res=rand("Normal", &&m&i.., &sd.);
        res_true=&&m&i..;
        output;
      %end;

      arm=9; *=zΏƌQ;
      res=rand("Normal", &m9., &sd.);
      res_true=&m9.;
      output;
    end;
  end;
  drop i;
run;

proc sort data=data01;
  by sim arm stage ;
run;
*===================================================================;

*===pʑI================================================;
/*===============================================
data01ɊÂCȉ2̃f[^Zbg𐶐
@sel_arms : Iꂽpʂ̃R[hf[^
  ϐsim, arm, cond_min
   sim: V~[V̌JԂԍ(1`&nsim.)
   arm: Iꂽp
   cond_min: 𖞂ŒpʃtO

Acnt : Ipʐ̃f[^
  ϐsim, cnt
   sim: V~[V̌JԂԍ(1`&nsim.)
   cnt: Ipʐ
================================================*/

proc means data=data01;
  where stage=1;
  by sim arm;
  var res;
  output out=mean1(drop=_:) mean=mean;
run;

data mean2;
  merge
mean1(where=(arm notin(0,9)))
mean1(where=(_arm=0) rename=(mean=mean0 arm=_arm) )
mean1(where=(_arm=9) rename=(mean=mean9 arm=_arm) );
  by sim;
  diff0=mean-mean0; *=vZ{QƂ̌Qԍ;
  diff9=mean-mean9; *=zΏƌQƂ̌Qԍ;

  *=pʑI=======================================;
  if diff0>0.4 & diff9>0 then cond=1; else cond=0; *=𖞂pʂŃtOcond𗧂Ă;
  *====================================================;
run;

*=pʑI𖞂Œpʂ;
proc sort data=mean2 out=mean2_cond(keep=sim arm cond);
  where cond=1;
  by sim arm;
run;

data mean2_cond_min(rename=(cond=cond_min));
  set mean2_cond;
  by sim arm;
  if first.sim; *=𖞂Œp;
run;

proc sort data=mean2;
  %if &rule.=L %then by sim descending arm; ; *=𖞂ŒpʂƁCႢpʂI;
  %if &rule.=H %then by sim arm; ; *=𖞂ŒpʂƁC荂pʂI;
run;

*=f[^Zbgsel_armscnt̐;
data sel_arms(keep=sim arm cond_min selected) cnt(keep=sim cnt);
  merge mean2 mean2_cond_min;
  %if &rule.=L %then by sim descending arm; ;
  %if &rule.=H %then by sim arm; ;

  selected=1;

  retain cond_retain cnt 0;
  if first.sim then do; cond_retain=0; cnt=0; end;

  if cond_min=1 then cond_retain=1; *=𖞂ŒpʂƁC艺obsŃtO=1;

  if cond_retain=1 and cnt<&maxsel. then do; *=IpʐmaxselɂȂ܂output;
    cnt+1;
    output sel_arms;
  end;

  if last.sim then output cnt;
run;

*===pʑI܂================================================;

*=Iꂽp;
proc sort data=sel_arms;
  by sim arm;
run;

proc transpose data=sel_arms out=tr_sel_arms(drop=_:) prefix=selfl;
  by sim;
  id arm;
  var selected;
run;

data tr_sel_arms;
  format sim selfl1-selfl&narm. selfl9;
  set tr_sel_arms;

  if n(of selfl1-selfl&narm.)>=1 then selfl9=1;
run;

*=eQ̑I̓o;
data sel_arms_freq;
  set sel_arms end=eof;
  by sim arm;
  array sel{&narm.} sel1-sel&narm.;
  array sel_min{&narm.} sel_min1-sel_min&narm.; *=𖞂Œp;
  retain sel1-sel&narm. sel_min1-sel_min&narm. 0;

  do i=1 to &narm.;
    if arm=i then sel{i}+1/&nsim.;
    if arm=i and cond_min=1 then sel_min{i}+1/&nsim.;
  end;

  drop sim arm i cond_min;
  if eof;
run;

*=IpʐFv񓝌v;
proc means data=cnt noprint;
  var cnt;
  output out=cnt_mean(drop=_:) mean=cnt_mean std=cnt_std
  min=cnt_min q1=cnt_q1 median=cnt_median q3=cnt_q3 max=cnt_max;
run;

*=IpʐFpxWv;
proc freq data=cnt noprint;
  tables cnt/out=cnt_freq;
run;
proc transpose data=cnt_freq out=tr_cnt_freq(drop=_:) prefix=CNT;
  id cnt;
  var COUNT;
run;

data tr_cnt_freq;
  format CNT0-CNT&maxsel. PCT0-PCT&maxsel.;
  set tr_cnt_freq;

  %do i=0 %to &maxsel.;
    if CNT&i.=. then CNT&i.=0;
    PCT&i.=CNT&i./&nsim.;
    if PCT&i.=. then PCT&i.=0;
  %end;
run;

data out_sel;
  format no m1-m&narm. m9 sd rule nsim;
  merge cnt_mean tr_cnt_freq sel_arms_freq; *=ׂ1obs;
  
  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format rule $rule.;
run;

*=ʂivCuɕۑ==================;
proc append base=lib.out_sel data=out_sel;
run;
*=============================================;

*selectedFIQ̃tOD1Xe[Wł͗pʌQ̂IpʂуvZ{/zΏƌQ̃R[h1C2Xe[W͑SQ̃R[h1𗧂Ă;
*cntFIpʐ̕ϐ;

*=f[^ɑIꂽpsel_arms̃f[^}[W;
data data01;
  merge data01 sel_arms(in=a); *=sel_armsFpʌQ̃R[ĥݎf[^;
  by sim arm;

  if a then selected=1; *=̎_ł͗Xe[WɂpʌQ݂̂ɃtO;
run;

*=f[^Ɋepʂ̑ItOtr_sel_arms̃f[^}[W;
data data01;
  merge data01 tr_sel_arms;
  by sim;

  cnt=n(of selfl1-selfl&narm.);

  *=tOselected̍ŏI=======================================;
  if cnt>=1 and stage in(1,2) and arm in(0,9) then selected=1; *=1pʂłIꂽꍇCXe[WɂvZ{QzΏƌQłItO𗧂Ă;
  *==============================================================;

  *=R[h̑I===============================================;
  if cnt=0 and stage=2 then delete; *=Ipʐ0̏ꍇCSQ̑2Xe[W̃f[^폜;
  if selected ne 1 and stage=2 then delete; *=IQ̑2Xe[W̃f[^폜;
  *==============================================================;

  *=Step-down DunnettpFIQ̌蓝vʂɂ߂ďȂ悤Ƀf[^Vtg;
  if stage=1 and (arm notin(0, 9) and selected ne 1) then do;
    %if &side.=U %then res_dun=res-1E10; ;
    %if &side.=L %then res_dun=res+1E10; ;
  end;
  else res_dun=res;
run;
*=f[^Zbgdata01m;


*=ǗᐔCl̗v񓝌vʁCoCAX/MSEC핢m̕]===================;

%if %eval(&no.>=200) %then %do; *=o͂̃ViIł̂ݕ];

*=V~[V1񂲂Ƃ̐l;
proc means data=data01 noprint;
  where stage=1; *=1Xe[W;
  by sim arm stage res_true;
  var res;
  output out=est_st01(drop=_:) n=n mean=mean std=std;
run;
proc means data=data01 noprint;
  where stage=2; *=2Xe[W;
  by sim arm stage res_true;
  var res;
  output out=est_st02(drop=_:) n=n mean=mean std=std;
run;
proc means data=data01 noprint;
  by sim arm res_true; *=Xe[W;
  var res;
  output out=est_st09(drop=_:) n=n mean=mean std=std;
run;
proc means data=data01 noprint;
  where stage=1 and selected=1; *=1Xe[WAIꂽƂt;
  by sim arm stage res_true;
  var res;
  output out=est_st11(drop=_:) n=n mean=mean std=std;
run;
proc means data=data01 noprint;
  where selected=1; *=Xe[WAIꂽƂt;
  by sim arm res_true;
  var res;
  output out=est_st19(drop=_:) n=n mean=mean std=std;
run;
proc means data=data01 noprint;
  where selected ne 1 and stage=1; *=IȂƂt(1Xe[Ŵ)AvZ{Q͏Ȃ;
  by sim arm stage res_true;
  var res;
  output out=est_st21(drop=_:) n=n mean=mean std=std;
run;

*=UMVCUEp==========================================;

%macro rqserch(rank=); *-UMVCUEZoɗpW̐;
%if &rank. = &narm. %then %do; *=ʂnarmԖ=ʍŏ̌Q̏ꍇ;
data _wl;
  set umv02;
  if rank_st01 = %eval(&rank. - 1);
  keep sim mean_st01;
  rename mean_st01=mean_st01_m1;
run;

data __wl;
  merge umv02(where=(rank_st01 = &rank.)) _wl;
  by sim;
  rank_st01=&rank.;
  wlp1 = 99999999; * infinity ;
  wlm1 = sqrt(n_st01 * (n_st01 + n_st02)/n_st02) / &sd. *(Zl / (n_st01 + n_st02) - mean_st01_m1);
  keep sim rank_st01 wlp1 wlm1;
run;
%end;

%else %if &rank. = 1 %then %do; *=ʂ1Ԗ=ʍő̌Q̏ꍇ;
data _wl;
  set umv02;
  if rank_st01 = %eval(&rank. + 1);
  keep sim mean_st01;
  rename mean_st01=mean_st01_p1;
run;

data __wl;
  merge umv02(where=(rank_st01 = &rank.)) _wl;
  by sim;
  rank_st01=&rank.;
  wlp1 = sqrt(n_st01 * (n_st01 + n_st02)/n_st02) / &sd. *(Zl / (n_st01 + n_st02) - mean_st01_p1);
  wlm1 = -99999999; * -infinity ;
  keep sim rank_st01 wlp1 wlm1;
run;
%end;

%else %do; *=ʂ1ԖڂłnarmԖڂłȂꍇ;
data _wl1;
  set umv02;
  if rank_st01 = %eval(&rank. - 1);
  keep sim mean_st01;
  rename mean_st01=mean_st01_m1;
run;

data _wl2;
  set umv02;
  if rank_st01 = %eval(&rank. + 1);
  keep sim mean_st01;
  rename mean_st01=mean_st01_p1;
run;

data __wl;
  merge umv02(where=(rank_st01 = &rank.)) _wl1 _wl2;
  by sim;
  rank_st01=&rank.;
  wlp1 = sqrt(n_st01 * (n_st01 + n_st02)/n_st02) / &sd. *(Zl / (n_st01 + n_st02) - mean_st01_p1);
  wlm1 = sqrt(n_st01 * (n_st01 + n_st02)/n_st02) / &sd. *(Zl / (n_st01 + n_st02) - mean_st01_m1);
  keep sim rank_st01 wlp1 wlm1;
run;
%end;

proc append base=wl data=__wl;
run;
%mend rqserch;

%macro umvcue(inds, outds);

proc rank data=&inds. out=umv01 %if &side.=U %then descending; ;
  where stage=1 and arm notin(0,9);
  by sim;
  var mean;
  ranks rank_st01; *=1Xe[W̕ϒlɊÂNt;
run;

data umv02;
  merge umv01(rename=(n=n_st01 mean=mean_st01 std=std_st01)) &inds.(where=(stage=2 and arm notin(0,9)) rename=(n=n_st02 mean=mean_st02 std=std_st02));
  by sim arm;
  Zl = n_st01 * mean_st01 + n_st02 * mean_st02;
  drop stage;
run;

proc datasets lib=work nolist; delete wl; quit;
%do rank=1 %to &narm.; *=1Xe[W̌ʂ̏ԂƂW𐄒;
  %rqserch(rank=&rank.);
%end;

proc sql;
  create table &outds. as
  select umv02.*, wl.wlp1, wl.wlm1,
  Zl/(n_st01 + n_st02) as mle,  
  Zl/(n_st01 + n_st02) - sqrt(n_st01/(n_st02 * (n_st01 +n_st02))) * &sd. * (PDF('NORMAL', wl.wlp1) - PDF('NORMAL', wl.wlm1)) / (CDF('NORMAL', wl.wlp1) - CDF('NORMAL', wl.wlm1)) as umvcue
  from umv02
  left join wl
  on umv02.sim=wl.sim and umv02.rank_st01=wl.rank_st01
  where Zl ne .
  ;
quit;

%mend umvcue;

data est_st0102; *=UMVCUE̓_lZop;
  set est_st01 est_st02;
run;

%umvcue(est_st0102, umv); *=UMVCUE̐;

data est_st0102_; *=UMVCUECIZop;
  set est_st0102;
  mean=mean-res_true; *=ێIUMCUE̕Û߁ASQ̊Ғl𓙂;
run;

%umvcue(est_st0102_, umv_std); *=UMVUCUECIZoɗp镪U;

proc sort data=umv_std;
  by rank_st01;
run;
proc univariate data=umv_std noprint;
  by rank_st01;
  var umvcue;
  output out=umv_std1 std=umv_std;
run;

proc sql;
  create table est_st19_umv as
  select umv.*, umv_std1.umv_std, n_st01+n_st02 as n from umv
  left join umv_std1
  on umv.rank_st01=umv_std1.rank_st01
  order by sim, arm
  ;
quit;

*=UMVCUEp܂==========================================;

*=V~[VƂ̊eQ̐܂Ƃ============================================================;
data est_st19; *=iC[uɏʂǉ;
  merge est_st19(in=a) est_st19_umv(keep=sim arm rank_st01);
  by sim arm;
  if a;
run;
data est10;
  set
est_st01 est_st02 est_st09(in=c)
est_st11(in=d) est_st19(in=e) est_st19_umv(in=f rename=(umvcue=mean))
est_st21(in=g)
;
  format estimate estimate.;

  if c or e or f then stage=9; *=Xe[W;
  if d or e or f then stage=stage+10; *=IꂽƂt;
  if g then stage=stage+20; *=IȂƂt(1Xe[Ŵ);

  if not f then estimate=1; *=MLE;
  if f then estimate=2; *=UMVCUE;
  
  *=eQ̕ϒl̐M;
  if estimate=1 then do; *=MLE;
    lclm=mean-tinv(0.975, n-1)*std/sqrt(n);
    uclm=mean+tinv(0.975, n-1)*std/sqrt(n);
  end;
  if estimate=2 then do; *=UMVCUE;
    lclm=mean-quantile('NORMAL', 0.975)*umv_std;
    uclm=mean+quantile('NORMAL', 0.975)*umv_std;
  end;

  *=oCAXAMSEA핢m;
  if .<lclm<res_true<uclm then covfl=1; *=핢m;
  else if .<lclm then covfl=0;

  _bias=mean-res_true;
  _sq_bias=_bias**2;
run;

*=SV~[Vɂ鐄l̗v;
proc sort data=est10;
  by arm stage estimate;
run;

proc sort data=est10 out=est10_byrank;
  where rank_st01 ne . and stage=19;
  by rank_st01 stage estimate; *=ʂƂ̐l̐\(rank_st01F);
run;

proc means data=est10 noprint;
  by arm stage estimate;
  output out=est20(drop=_:)
n(mean)=est_n mean(mean)=est_mean std(mean)=est_std min(mean)=est_min q1(mean)=est_q1 median(mean)=est_med q3(mean)=est_q3 max(mean)=est_max
mean(_bias)=bias mean(_sq_bias)=mse
mean(covfl)=cov_prob
;
run;

proc means data=est10_byrank noprint;
  by rank_st01 stage estimate;
  output out=est20_byrank(drop=_:)
n(mean)=est_n mean(mean)=est_mean std(mean)=est_std min(mean)=est_min q1(mean)=est_q1 median(mean)=est_med q3(mean)=est_q3 max(mean)=est_max
mean(_bias)=bias mean(_sq_bias)=mse
mean(covfl)=cov_prob
;
run;

data est21;
  format no m1-m&narm. m9 sd rule nsim stage estimate arm;
  set est20;

  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format stage stage. rule $rule. arm arm.;
run;

data est21_byrank;
  format no m1-m&narm. m9 sd rule nsim stage estimate rank_st01;
  set est20_byrank;

  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format stage stage. rule $rule.;
run;

*=ʂivCuɕۑ==================;
proc append base=lib.out_est data=est21;
run;
proc append base=lib.out_est_byrank data=est21_byrank;
run;
*=============================================;

*=Qԍ̐܂Ƃ============================================================;
*est10̃\[gGby arm stage estimate sim;
proc sort data=est10 out=est11(keep=sim arm rank_st01 stage estimate n mean std umv_std);
  by sim stage arm estimate;
run;

proc sql;
  *=@stage in(1,2,19)ɂvZ{Q̌ʂ}[W;
  *=--stage=19estimate in(1,2)ǂvZ{Qestimate=1(MLE)ƃ}[WĂ_ɒ;
  create table est_diff01 as
  select A.*, B.n as n0, B.mean as mean0, B.std as std0
  from est11(where=(arm notin(0) and stage in(1,2,19))) as A
  left join est11(where=(arm=0 and stage in(1,2,19))) as B
  on A.sim=B.sim and A.stage=B.stage;

  *=Astage=21̌ʂƃvZ{Qstage=1̌ʂ}[W;
  create table est_diff02 as
  select A.*, B.n as n0, B.mean as mean0, B.std as std0
  from est11(where=(arm notin(0) and stage in(21))) as A
  left join est11(where=(arm=0 and stage in(1))) as B
  on A.sim=B.sim;
quit;

*=stage=9ɂvZ{Q̌ʂ;
*=YQIĂꍇ͗Xe[W(stage=19)AIĂȂꍇ͑1Xe[W(stage=1);
proc sql;
  create table est_st09_plc01 as
  select A.sim, A.arm,
  A.n as n_st01, A.mean as mean_st01, A.std as std_st01,
  B.n as n_st19, B.mean as mean_st19, B.std as std_st19 
  from est10(where=(arm=0 and stage=1)) as A
  left join est10(where=(arm=0 and stage=19)) as B
  on A.sim=B.sim;

  create table est_st09_plc02(drop=sim_) as
  select * from est_st09_plc01 as A
  left join tr_sel_arms(rename=(sim=sim_)) as  B
  on A.sim=B.sim_;
quit;

data est_st09_plc03;
  set est_st09_plc02;
  %do i=1 %to &narm.;
    if selfl&i.=1 then do;
      arm=&i.;
      n0=n_st19; mean0=mean_st19; std0=std_st19;
      output;
    end;
    else do;
      arm=&i.;
      n0=n_st01; mean0=mean_st01; std0=std_st01;
      output;
    end;
  %end;
  if selfl9=1 then do;
    arm=9;
    n0=n_st19; mean0=mean_st19; std0=std_st19;
    output;
  end;
  else do;
    arm=9;
    n0=n_st01; mean0=mean_st01; std0=std_st01;
    output;
  end;
  keep sim arm n0 mean0 std0;
run;

proc sql;
  *=Bstage=9ɂvZ{Q̌ʂ}[W;
  create table est_diff03 as
  select A.*, B.n0, B.mean0, B.std0
  from est11(where=(arm notin(0) and stage in(9))) as A
  left join est_st09_plc03 as B
  on A.sim=B.sim and A.arm=B.arm;

  *=@AB̃f[^Zbgcς;
  create table est_diff10 as
  select * from est_diff01 union
  select * from est_diff02 union
  select * from est_diff03
  order by sim, stage, arm
;
quit;

data est_diff11;
  set est_diff10;

  *=ϒl̍̐;
  diff=mean-mean0;

  if estimate=1 then do; *=MLE;
    pooled_se=sqrt( ((n-1)*std**2+(n0-1)*std0**2) / (n+n0-2) ) * sqrt(1/n + 1/n0);
    diff_lclm=diff - pooled_se * tinv(0.975, n+n0-2);
    diff_uclm=diff + pooled_se * tinv(0.975, n+n0-2);
  end;
  if estimate=2 then do; *=UMVCUE;
    pooled_se=sqrt(umv_std**2+(std0/sqrt(n0))**2);
    diff_lclm=diff - pooled_se * quantile('NORMAL', 0.975);
    diff_uclm=diff + pooled_se * quantile('NORMAL', 0.975);
  end;

  *=oCAXAMSEA핢m;
  %do i=1 %to &narm.;
    if arm=&i. then diff_true=&&m&i..-&m0.;
  %end;
  if arm=9 then diff_true=&m9.-&m0.;

  if .<diff_lclm<diff_true<diff_uclm then covfl=1; *=핢m;
  else if .<diff_lclm then covfl=0;

  _bias=diff-diff_true;
  _sq_bias=_bias**2;

  if n*n0 ne . and n ne n0 then putlog "E" "RROR";
run;

*=SV~[Vɂ鐄l̗v;
proc sort data=est_diff11;
  by arm stage estimate;
run;

proc sort data=est_diff11 out=est_diff11_byrank;
  where rank_st01 ne . and stage=19;
  by rank_st01 stage estimate; *=ʂƂ̐l̐\(rank_st1F);
run;

proc means data=est_diff11 noprint;
  by arm stage estimate;
  output out=est_diff20(drop=_:)
n(diff)=est_n mean(diff)=est_mean std(diff)=est_std min(diff)=est_min q1(diff)=est_q1 median(diff)=est_med q3(diff)=est_q3 max(diff)=est_max
mean(_bias)=bias mean(_sq_bias)=mse
mean(covfl)=cov_prob
;
run;

proc means data=est_diff11_byrank noprint;
  by rank_st01 stage estimate;
  output out=est_diff20_byrank(drop=_:)
n(diff)=est_n mean(diff)=est_mean std(diff)=est_std min(diff)=est_min q1(diff)=est_q1 median(diff)=est_med q3(diff)=est_q3 max(diff)=est_max
mean(_bias)=bias mean(_sq_bias)=mse
mean(covfl)=cov_prob
;
run;

data est_diff21;
  format no m1-m&narm. m9 sd rule nsim stage estimate arm;
  set est_diff20;

  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format stage stage. rule $rule. arm arm.;
run;

data est_diff21_byrank;
  format no m1-m&narm. m9 sd rule nsim stage estimate rank_st01;
  set est_diff20_byrank;

  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format stage stage. rule $rule.;
run;

*=ʂivCuɕۑ==================;
proc append base=lib.out_est_diff data=est_diff21;
run;
proc append base=lib.out_est_diff_byrank data=est_diff21_byrank;
run;
*=============================================;

%end; *=o͂̃ViIł̂ݕ];
*============================================================================;

data dummy_simarm;
  do sim=1 to &nsim.;
  do arm=1 to &narm.;
    output;
  end; end;
run;

*=@tK@=================================================================;
*=1ViȊSV~[VɂĈx1pʂIȂꍇւ̑Ώ;
data inv_stage1_0;
  sim=.;arm=.; Adjp=.;
  delete;
run;
data inv_stage2_0;
  sim=.;arm=.; Adjp=.;
  delete;
run;

%do i=0 %to %eval(&rep.); *=V~[V񐔂10000𒴂ꍇCɎs;

*=1Xe[Wpl(Bonferroni);
title "Inverse Normal (stage 1)";
ods output diffs=inv_stage1_&i.;
proc mixed data=data01 order=data;
  where (&&st&i.. <= sim <= &&en&i..) and stage=1 and arm notin(9) and cnt>=1; *=zΏƌQ͑Δ䂩珜OCIQ0̏ꍇO;
  by sim;
  class arm;
  model res=arm;
  %if &side.=U %then lsmeans arm/pdiff=controlu("0") alpha=0.025 adjust=bon; ;
  %if &side.=L %then lsmeans arm/pdiff=controll("0") alpha=0.025 adjust=bon; ;
run;
title;

*=2Xe[Wpl(Bonferroni);
title "Inverse Normal (stage 2)";
ods output diffs=inv_stage2_&i.;
proc mixed data=data01 order=data;
  where (&&st&i.. <= sim <= &&en&i..) and stage=2 and arm notin(9) and cnt>=1; *=zΏƌQ͑Δ䂩珜OCIQ0̏ꍇO;
  by sim;
  class arm;
  model res=arm;
  %if &side.=U %then lsmeans arm/pdiff=controlu("0") alpha=0.025 adjust=bon; ;
  %if &side.=L %then lsmeans arm/pdiff=controll("0") alpha=0.025 adjust=bon; ;
run;
title;

%end;

data inv_stage1;
  set inv_stage1_0-inv_stage1_&rep.; *=10000񂲂Ƃ̌ʂ𓝍;
  %if &side.=L %then %do; *=̏ꍇ͕ϐ_ARMpʌQƂȂ邽߁Cl[;
    drop ARM;
    rename _ARM=ARM;
  %end;
run;
data inv_stage2;
  set inv_stage2_0-inv_stage2_&rep.; *=10000񂲂Ƃ̌ʂ𓝍;
  %if &side.=L %then %do; *=̏ꍇ͕ϐ_ARMpʌQƂȂ邽߁Cl[;
    drop ARM;
    rename _ARM=ARM;
  %end;
run;


*=Бpľ;
data inv01;
  merge
inv_stage1(keep=sim arm Adjp rename=(Adjp=Adjp_stage1))
inv_stage2(keep=sim arm Adjp rename=(Adjp=Adjp_stage2) in=a)
sel_arms(in=a)
;
  by sim arm;
  if a then selected=1;
run;

data inv02;
  set inv01;
  if selected=1 then do; *=IQ̂݋tK@̌vZs;

    *=tK@̏dw1,w2: eXe[W̗ᐔ/Q====;
    w1=sqrt(&n1./&n.);
    w2=sqrt(&n2./&n.);
    *=============================================;

    Adjp_stage1=round(Adjp_stage1,1E-20); *=plprobitZołȂꍇւ̑Ώ;
    Adjp_stage2=round(Adjp_stage2,1E-20);

    if Adjp_stage1 notin(.,0,1) then z_stage1=-probit(Adjp_stage1);
    if Adjp_stage1=1 then z_stage1=-8.222; *=SAS Helpprobit֐̐ɉĐݒ;
    if Adjp_stage1=0 then z_stage1=-probit(1E-20);

    if Adjp_stage2 notin(.,0,1) then z_stage2=-probit(Adjp_stage2);
    if Adjp_stage2=1 then z_stage2=-8.222;
    if Adjp_stage2=0 then z_stage2=-probit(1E-20);

    z_lm=w1*z_stage1 + w2*z_stage2;
    inv_p=1-probnorm(z_lm);

    if .<inv_p<0.025 then rejected=1;
  end;
run;

data inv10;
  merge dummy_simarm inv02;
  by sim arm;

  keep sim arm inv_p selected rejected;
run;
*============================================================================;

*=Astep-down Dunnett========================================================;
*=1ViȊSV~[VɂĈx1pʂIȂꍇւ̑Ώ;
data dun_0;
  sim=.;arm=.; Adjp=.;
  delete;
run;

%do i=0 %to %eval(&rep.); *=V~[V񐔂10000𒴂ꍇCɎs;

title "step-down Dunnett";
ods output diffs=dun_&i.;
proc orthoreg data=data01;
  where (&&st&i.. <= sim <= &&en&i..) and arm notin(9) and cnt>=1; *=zΏƌQ͑Δ䂩珜OCIQ0̏ꍇO;
  by sim;
  class arm;
  model res_dun=arm;
  %if &side.=U %then lsmeans arm/pdiff=controlu("0") adjust=dunnett stepdown alpha=0.025; ;
  %if &side.=L %then lsmeans arm/pdiff=controll("0") adjust=dunnett stepdown alpha=0.025; ;
run;
title;

%end;

data dun;
  set dun_0-dun_&rep.; *=10000񂲂Ƃ̌ʂ𓝍;
  %if &side.=L %then %do; *=̏ꍇ͕ϐ_ARMpʌQƂȂ邽߁Cl[;
    drop ARM;
    rename _ARM=ARM;
  %end;
run;

data dun01;
  merge dun sel_arms(in=a);
  by sim arm;

  if a then selected=1;

  if .<Adjp<0.025 then rejected=1;
  
  keep sim arm Adjp selected rejected;
run;

data dun10;
  merge dummy_simarm dun01;
  by sim arm;
run;

*=Jstep-down Dunnett (operationally seamless)===============================;
*=1ViȊSV~[VɂĈx1pʂIȂꍇւ̑Ώ;
data osdun_0;
  sim=.;arm=.; Adjp=.;
  delete;
run;

%do i=0 %to %eval(&rep.); *=V~[V񐔂10000𒴂ꍇCɎs;

title "step-down Dunnett (operationally seamless)";
ods output diffs=osdun_&i.;
proc orthoreg data=data01;
  where (&&st&i.. <= sim <= &&en&i..) and (selected=1 and stage=2) and arm notin(9) and cnt>=1; *=zΏƌQ͑Δ䂩珜OCIQ0̏ꍇO;
  by sim;
  class arm;
  model res_dun=arm;
  %if &side.=U %then lsmeans arm/pdiff=controlu("0") adjust=dunnett stepdown alpha=0.025; ;
  %if &side.=L %then lsmeans arm/pdiff=controll("0") adjust=dunnett stepdown alpha=0.025; ;
run;
title;

%end;

data osdun;
  set osdun_0-osdun_&rep.; *=10000񂲂Ƃ̌ʂ𓝍;
  %if &side.=L %then %do; *=̏ꍇ͕ϐ_ARMpʌQƂȂ邽߁Cl[;
    drop ARM;
    rename _ARM=ARM;
  %end;
run;

data osdun01;
  merge osdun sel_arms(in=a);
  by sim arm;

  if a then selected=1;

  if .<Adjp<0.025 then rejected=1;

  keep sim arm Adjp selected rejected;
run;

data osdun10;
  merge dummy_simarm osdun01;
  by sim arm;
run;
*============================================================================;

*=3@̂܂Ƃ==============================================================;
data test01;
  set inv10(in=a) dun10(in=b) osdun10(in=c);

  format method method. rule $rule.;

  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  if a then method=1;
  if b then method=2;
  if c then method=11;
run;

proc sort data=test01;
  by sim;
run;

data test02; *=Ipʐcnt}[W;
  merge cnt test01;
  by sim;
run;

proc sort data=test02;
  by method sim arm;
run;

data test10;
  format no m1-m&narm. m9 sd rule nsim method sel1-sel&narm. rej1-rej&narm. rej_cond1-rej_cond&narm.
         rej_true_null rej_false_null;

  set test02;
  by method sim arm;

  %do i=1 %to &narm.;
    if arm=&i. then res_true=&&m&i..;
  %end;
  if res_true=0 then zfl=1; *=ʂ̐^l0̏ꍇ1ƂȂtO;
  else zfl=0;

  array sel{&narm.} sel1-sel&narm.;
  array rej{&narm.} rej1-rej&narm.;
  array rej_cond{&narm.} rej_cond1-rej_cond&narm.;

  retain sel1-sel&narm. rej1-rej&narm. rej_cond1-rej_cond&narm. 0;

  if first.method then do;
    %do i=1 %to &narm.;
      sel&i.=0;
      rej&i.=0;
      rej_cond&i.=0;
    %end;
  end;

  *=^QƂ̑Im/pmo;
  do i=1 to &narm.;
    if arm=i then sel{i}+selected/&nsim.;
    if arm=i then rej{i}+rejected/&nsim.;
    if arm=i & sel{i} ne 0 then rej_cond{i}=rej{i}/sel{i};
  end;
  
  *=pʌQŜł̓o;
  retain rej_true_null_retain rej_true_null rej_false_null_retain rej_false_null;

  *=ʂ0̌Qꂩ1Qłreject (Type 1 ERR): rej_true_null;
  *=ʂ0̌Qꂩ1Qłreject (Power): rej_false_null;
  if first.method then do;
    rej_true_null=0;
    rej_false_null=0;
  end;

  if first.sim then do;
    rej_true_null_retain=0;
    rej_false_null_retain=0;
  end;

  if rejected*zfl=1 then rej_true_null_retain=1; *=V~[V1Ōʂ0̌Q̂ꂩreject̏ꍇ1;
  if rejected*not(zfl)=1 then rej_false_null_retain=1; *=V~[V1Ōʂ0̂ꂩreject̏ꍇ1;

  if last.sim then do;
    rej_true_null+rej_true_null_retain/&nsim.;
    rej_false_null+rej_false_null_retain/&nsim.;
  end;

  keep no m1-m&narm. m9 sd rule nsim method sel1-sel&narm. rej1-rej&narm. rej_cond1-rej_cond&narm.
       rej_true_null rej_false_null;

  if last.method;
run;
*============================================================================;

*=ʂivCuɕۑ==================;
proc append base=lib.out_test data=test10;
run;
*=============================================;

*=Ԍv====================================;
data _NULL_;
  call symput("end_time", datetime());
run;

data time;
  no=&no.;
  %do i=1 %to &narm.;
    m&i.=&&m&i..;
  %end;
  m9=&m9.;
  sd=&sd.;
  rule="&rule.";
  nsim=&nsim.;

  format rule $rule.;

  start=put(input(&start_time.,  best.), NLDATMS19.);
  end=put(input(&end_time.,  best.), NLDATMS19.);
  time=put(input(&end_time.,  best.)-input(&start_time.,  best.), time7.);
run;
*=============================================;

*=ʂivCuɕۑ==================;
proc append base=lib.out_time data=time;
run;
*=============================================;

%mend TSsim;

%macro exe;

*=̉ߌm̌ViI==============;
%TSsim(100,   0,   0,   0,   0,   0);

%TSsim(101, 0.5,   0,   0,   0,   0);
%TSsim(102,   0, 0.5,   0,   0,   0);
%TSsim(103,   0,   0, 0.5,   0,   0);
%TSsim(104,   0,   0,   0, 0.5,   0);

%TSsim(105, 0.5, 0.5,   0,   0,   0);
%TSsim(106, 0.5,   0, 0.5,   0,   0);
%TSsim(107, 0.5,   0,   0, 0.5,   0);
%TSsim(108,   0, 0.5, 0.5,   0,   0);
%TSsim(109,   0, 0.5,   0, 0.5,   0);
%TSsim(110,   0,   0, 0.5, 0.5,   0);

%TSsim(111, 0.5, 0.5, 0.5,   0,   0);
%TSsim(112, 0.5, 0.5,   0, 0.5,   0);
%TSsim(113, 0.5,   0, 0.5, 0.5,   0);
%TSsim(114,   0, 0.5, 0.5, 0.5,   0);
*=============================================;

*=o͂̌ViI========================;
*=={p^[==;
%TSsim(201, 0.4, 0.5,   0.5,   0.5, 0.4); *=Q2œł;
%TSsim(202, 0.4, 0.45,  0.5,   0.5, 0.4); *=Q3œł;
%TSsim(203, 0.4, 0.433, 0.467, 0.5, 0.4); *=Q4܂ŗpʔ;
%TSsim(204, 0.4, 0.4,   0.5,   0.5, 0.4); *=Q1ƌQ2;

*==zΏƌQ̌ʂ0.1Ⴂp^[==;
%TSsim(205, 0.4, 0.5,   0.5,   0.5, 0.3);
%TSsim(206, 0.4, 0.45,  0.5,   0.5, 0.3);
%TSsim(207, 0.4, 0.433, 0.467, 0.5, 0.3);
%TSsim(208, 0.4, 0.4,   0.5,   0.5, 0.3);

*=============================================;

%mend exe;
